IF NOT OBJECT_ID('PDV_VD_TEF_CONCILIACAO') IS NULL
begin
	DROP TABLE [dbo].[PDV_VD_TEF_CONCILIACAO]
END
GO
GO
IF OBJECT_ID('RC_CONC_PDV_VD_TEF_CONCILIADO') IS NULL
begin
CREATE TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO](
	[CD_EMP] [int] NOT NULL,
	[CD_CTR_LOTE] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_VD] [int] NOT NULL,
	[CD_CTR] [int] NOT NULL,
	[DT_CONCILIACAO] [datetime] NOT NULL,
	[HORA_CONCILIACAO] [datetime] NOT NULL,
	[NR_PROTOCOLO] [varchar](150) NOT NULL,
 CONSTRAINT [PK_RC_CONC_PDV_VD_TEF_CONCILIADO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_CTR_LOTE] ASC,
	[CD_FILIAL] ASC,
	[CD_VD] ASC,
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_CD_CTR_LOTE]  DEFAULT ((0)) FOR [CD_CTR_LOTE]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_CD_VD]  DEFAULT ((0)) FOR [CD_VD]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_DT_CONCILIACAO]  DEFAULT (getdate()) FOR [DT_CONCILIACAO]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_HORA_CONCILIACAO]  DEFAULT (getdate()) FOR [HORA_CONCILIACAO]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] ADD  CONSTRAINT [DF_RC_CONC_PDV_VD_TEF_CONCILIADO_NR_PROTOCOLO]  DEFAULT ('') FOR [NR_PROTOCOLO]

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO]  WITH CHECK ADD  CONSTRAINT [FK_RC_CONC_PDV_VD_TEF_CONCILIADO_RC_CONC_PDV_VD_TEF] FOREIGN KEY([CD_EMP], [CD_CTR_LOTE], [CD_FILIAL], [CD_VD], [CD_CTR])
REFERENCES [dbo].[RC_CONC_PDV_VD_TEF] ([CD_EMP], [CD_CTR_LOTE], [CD_FILIAL], [CD_VD], [CD_CTR])

ALTER TABLE [dbo].[RC_CONC_PDV_VD_TEF_CONCILIADO] CHECK CONSTRAINT [FK_RC_CONC_PDV_VD_TEF_CONCILIADO_RC_CONC_PDV_VD_TEF]
end
